/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import noppes.npcs.CustomNpcs;
import org.apache.logging.log4j.LogManager;

public class CustomNpcsPermissions {
    public static Permission EDIT_BLOCKS = new Permission("customnpcs.edit.blocks");
    public static Permission EDIT_VILLAGER = new Permission("customnpcs.edit.villager");
    public static Permission GLOBAL_BANK = new Permission("customnpcs.global.bank");
    public static Permission GLOBAL_DIALOG = new Permission("customnpcs.global.dialog");
    public static Permission GLOBAL_FACTION = new Permission("customnpcs.global.faction");
    public static Permission GLOBAL_LINKED = new Permission("customnpcs.global.linked");
    public static Permission GLOBAL_MARKET = new Permission("customnpcs.global.marcet");
    public static Permission GLOBAL_NATURAL_SPAWN = new Permission("customnpcs.global.naturalspawn");
    public static Permission GLOBAL_PLAYERDATA = new Permission("customnpcs.global.playerdata");
    public static Permission GLOBAL_QUEST = new Permission("customnpcs.global.quest");
    public static Permission GLOBAL_RECIPE = new Permission("customnpcs.global.recipe");
    public static Permission GLOBAL_TRANSPORT = new Permission("customnpcs.global.transport");
    public static CustomNpcsPermissions Instance;
    public static Permission NPC_ADVANCED;
    public static Permission NPC_CLONE;
    public static Permission NPC_CREATE;
    public static Permission NPC_DELETE;
    public static Permission NPC_DISPLAY;
    public static Permission NPC_FREEZE;
    public static Permission NPC_GUI;
    public static Permission NPC_INVENTORY;
    public static Permission NPC_RESET;
    public static Permission NPC_STATS;
    public static Permission SCENES;
    public static Permission SOULSTONE_ALL;
    public static Permission SPAWNER_CREATE;
    public static Permission SPAWNER_MOB;
    public static Permission TOOL_MOUNTER;
    public static Permission TOOL_NBT_BOOK;
    public static Permission TOOL_PATHER;
    public static Permission TOOL_SCRIPTER;
    public static Permission TOOL_TELEPORTER;

    public static boolean hasPermission(EntityPlayer player, Permission permission) {
        if (CustomNpcs.DisablePermissions) {
            return permission.defaultValue;
        }
        return CustomNpcsPermissions.hasPermissionString(player, permission.name);
    }

    public static boolean hasPermissionString(EntityPlayer player, String permission) {
        return CustomNpcs.DisablePermissions || PermissionAPI.hasPermission((EntityPlayer)player, (String)permission);
    }

    public CustomNpcsPermissions() {
        Instance = this;
        if (!CustomNpcs.DisablePermissions) {
            LogManager.getLogger(CustomNpcsPermissions.class).info("CustomNPC Permissions available:");
            Permission.permissions.sort((o1, o2) -> o1.name.compareToIgnoreCase(o2.name));
            for (Permission p : Permission.permissions) {
                PermissionAPI.registerNode((String)p.name, (DefaultPermissionLevel)(p.defaultValue ? DefaultPermissionLevel.ALL : DefaultPermissionLevel.OP), (String)p.name);
                LogManager.getLogger(CustomNpcsPermissions.class).info(p.name);
            }
        }
    }

    static {
        NPC_ADVANCED = new Permission("customnpcs.npc.advanced");
        NPC_CLONE = new Permission("customnpcs.npc.clone");
        NPC_CREATE = new Permission("customnpcs.npc.create");
        NPC_DELETE = new Permission("customnpcs.npc.delete");
        NPC_DISPLAY = new Permission("customnpcs.npc.display");
        NPC_FREEZE = new Permission("customnpcs.npc.freeze");
        NPC_GUI = new Permission("customnpcs.npc.gui");
        NPC_INVENTORY = new Permission("customnpcs.npc.inventory");
        NPC_RESET = new Permission("customnpcs.npc.reset");
        NPC_STATS = new Permission("customnpcs.npc.stats");
        SCENES = new Permission("customnpcs.scenes");
        SOULSTONE_ALL = new Permission("customnpcs.soulstone.all", false);
        SPAWNER_CREATE = new Permission("customnpcs.spawner.create");
        SPAWNER_MOB = new Permission("customnpcs.spawner.mob");
        TOOL_MOUNTER = new Permission("customnpcs.tool.mounter");
        TOOL_NBT_BOOK = new Permission("customnpcs.tool.nbtbook");
        TOOL_PATHER = new Permission("customnpcs.tool.pather");
        TOOL_SCRIPTER = new Permission("customnpcs.tool.scripter");
        TOOL_TELEPORTER = new Permission("customnpcs.tool.teleporter");
    }

    public static class Permission {
        private static final List<Permission> permissions = new ArrayList<Permission>();
        public boolean defaultValue = true;
        public String name;

        public Permission(String name) {
            this.name = name;
            permissions.add(this);
        }

        public Permission(String name, boolean defaultValue) {
            this.name = name;
            permissions.add(this);
            this.defaultValue = defaultValue;
        }
    }
}

